 ; Ŀ
 ;   Grim - draw a grid.                                                   
 ;   Copyright 2000, 2002, 2004, 2009 by Rocket Software Ltd.              
 ;   A happy program.                                                      
 ; 

 ; Ŀ
 ;   Bomax - Draw a box divided into a grid.                               
 ;   Takes four arguments - an upper left corner, a grid size, and the     
 ;   horizontal and vertical side lengths of one box.                      
 ; 
 (DEFUN BOMAX (pa divs celenh celenv / pasav pa2 pa3 pa4)
  (setq pasav pa)
 ; Ŀ
 ;   Draw the box.                                                         
 ; 
  (setq ovrlh (* divs celenh))
  (setq ovrlv (* divs celenv))
  (setq pa2 (polar pa 0 ovrlh))
  (setq pa3 (polar pa2 (* pi 1.5) ovrlv))
  (setq pa4 (polar pa3 pi ovrlh))
  (command ".pline" pa pa2 pa3 pa4 "c")
 ; Ŀ
 ;   And the grid lines.                                                   
 ; 
  (repeat (1- divs)
          (setq pa (polar pa (* pi 1.5) celenv))
          (setq pa2 (polar pa2 (* pi 1.5) celenv))
          (command ".line" pa pa2 ""))
  (setq pa pasav)
  (repeat (1- divs)
          (setq pa (polar pa 0 celenh))
          (setq pa4 (polar pa4 0 celenh))
          (command ".line" pa pa4 ""))
 (princ))
 ; Ŀ
 ;   Bomax end.                                                            
 ; 

 ; Ŀ
 ;   Grim.                                                                 
 ; 
 (DEFUN C:GRIM (/ *error* snapp blip pa grsiz sidlen)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq snapp (getvar "osmode"))
  (setvar "osmode" 0)
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
 ; Ŀ
 ;   Make a temporary local error handler.                                 
 ; 
  (defun *error* (shk)
   (setvar "osmode" snapp)
   (setvar "blipmode" blip)
   (command "undo" "end")
   (if shk (print shk))
  (princ))
 ; Ŀ
 ;   Get some parameters.                                                  
 ; 
  (setq grsiz (getint "\nNumber of boxes per side: "))
  (setq pa (getpoint "\nUpper left corner: "))
  (setq sidh (getdist pa "\nWidth of one box: "))
  (setq sidv (getdist pa "\nHeight of one box: "))
  (bomax pa grsiz sidh sidv)
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* ())
 (princ))